'use strict'

entityRegistry['module']['distort'] = {
    extendedInfo: {
        displayName: 'Distort',
        displayGroup: 'Post Processing',
    },
    init: (staticConfig) => {
        const {
        } = { ...staticConfig }

        const octaveData = [
            [0.030, 4.5,12.34, 0.5],
            [0.001, 2.22,1.99, 0.3],
            [0.123, 5.7,11.17, 0.2],
         ]
         const noiseRng = new Math.seedrandom('noise')
         const noiseData = new Float32Array([...Array(1000).keys()].map(x => noiseRng() * 2 - 1))
         return {
             octaveData,
             noiseData
         }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'strength', displayName: 'Strength', type: 'float', defaultValue: 1},
        { paramName: 'magnetDistance', displayName: 'Magnet Distance', type: 'float', defaultValue: 0},
        { paramName: 'distortDistance', displayName: 'Distort Distance', type: 'float', defaultValue: 20},
        { paramName: 'distortTime', displayName: 'Distort Time', type: 'float', defaultValue: 0},
        { paramName: 'brightness', displayName: 'Brightness', type: 'float', defaultValue: 0.5},
        { paramName: 'colorActive', displayName: 'Color Active', type: 'boolean', defaultValue: true},
        { paramName: 'brightnessActive', displayName: 'Brightness Active', type: 'boolean', defaultValue: true},
        { paramName: 'depthActive', displayName: 'Depth Active', type: 'boolean', defaultValue: true},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                strength,
                magnetDistance,
                distortDistance,
                distortTime,
                brightness,
                colorActive,
                brightnessActive,
                depthActive,
            } = { ...config }

            const doDistort = (bufferName, distortBrightness) => {
                if (true || strength > 0.1) {
                    const srcBufferId = renderer.getCurrentBufferId(bufferName)
                    const dstBufferId = renderer.lockBuffer(bufferName)
                    const srcBuffer = renderer.getBufferFromId(bufferName, srcBufferId)
                    const dstBuffer = renderer.getBufferFromId(bufferName, dstBufferId)
                    const srcBufferData = srcBuffer.data
                    const dstBufferData = dstBuffer.data
                    const bufferWidth = srcBuffer.width
                    const bufferHeight = srcBuffer.height

                    const magnetTime = frameTime * 1.57
                    const magnetTimeAlpha = magnetTime % 1
                    const magnetStrengthA = self.noiseData[Math.floor(frameTime) % self.noiseData.length]
                    const magnetStrengthB = self.noiseData[(Math.floor(frameTime) + 1) % self.noiseData.length]
                    const magnetStrength = (magnetStrengthA + (magnetStrengthB - magnetStrengthA) * magnetTimeAlpha) * 0.5 + 0.5
            
                    let writeIndex = 0
                    for (let y = 0; y < bufferHeight; ++y) {
                        let brightness = 1
                        if (distortBrightness > 0) {
                            brightness += 
                                Math.sin(-distortTime*1.21 + y*0.12)*distortBrightness*0.75 + 
                                Math.sin(+distortTime*1.53 + y*0.03)*distortBrightness*0.25
                        }
            
                        const readLine = bufferWidth * y
                        let distortValue = 0
                        for (let i = 0; i < self.octaveData.length; ++i) {
                            const octave = self.octaveData[i]
                            distortValue += self.noiseData[Math.floor(y*octave[0] + (frameTime+octave[1])*octave[2]) % self.noiseData.length] * octave[3]
                        }
                        distortValue *= distortDistance
                        distortValue += Math.pow(1-(y/bufferHeight), magnetStrength * 10 + 2) * magnetDistance * magnetStrength
                        distortValue *= strength
                        distortValue = Math.floor(distortValue)
                        if (distortValue > 0) {
                            let x = 0
                            const value = srcBufferData[readLine] * brightness
                            for (; x < distortValue; ++x) {
                                dstBufferData[writeIndex++] = value
                            }
                            let readIndex = 0
                            for (; x < bufferWidth; ++x) {
                                dstBufferData[writeIndex++] = srcBufferData[readLine + readIndex++] * brightness
                            }
                        } else {
                            let readIndex = -distortValue
                            let x = 0
                            let value
                            for (; x < bufferWidth + distortValue; ++x) {
                                value = srcBufferData[readLine + readIndex++] * brightness
                                dstBufferData[writeIndex++] = value
                            }
                            for (; x < bufferWidth; ++x) {
                                dstBufferData[writeIndex++] = value
                            }
                        }
                    }
            
                    renderer.unlockBuffer(bufferName, srcBufferId)
                    renderer.setCurrentBufferId(bufferName, dstBufferId)
                }
            }

            if (colorActive) doDistort('color', 0)
            if (depthActive) doDistort('depth', 0)
            if (brightnessActive) doDistort('brightness', brightness)
        }
    }
}
